/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.legacy.lucene;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.DlsFlsComplianceConfig;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.DlsFlsProcessedConfig;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.DlsQueryParser;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.lucene.DlsFlsFilterLeafReader;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.support.SgUtils;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;
import org.elasticsearch.indices.IndicesModule;

public class SearchGuardFlsDlsIndexSearcherWrapper
implements CheckedFunction<DirectoryReader, DirectoryReader, IOException> {
    private static final Set<String> metaFields = Sets.union((Set)Sets.newHashSet((Object[])new String[]{"_primary_term"}), (Set)Sets.newHashSet((Iterable)IndicesModule.getBuiltInMetadataFields()));
    private final ClusterService clusterService;
    private final IndexService indexService;
    private final DlsFlsComplianceConfig complianceConfig;
    private final AuditLog auditlog;
    private final LongSupplier nowInMillis;
    private final DlsQueryParser dlsQueryParser;
    private final ThreadContext threadContext;
    private final Index index;
    private final AtomicReference<DlsFlsProcessedConfig> config;

    public SearchGuardFlsDlsIndexSearcherWrapper(IndexService indexService, Settings settings, ClusterService clusterService, AuditLog auditlog, DlsFlsComplianceConfig complianceConfig, AtomicReference<DlsFlsProcessedConfig> config) {
        this.clusterService = clusterService;
        this.indexService = indexService;
        this.complianceConfig = complianceConfig;
        this.auditlog = auditlog;
        this.dlsQueryParser = new DlsQueryParser(indexService.xContentRegistry());
        this.threadContext = indexService.getThreadPool().getThreadContext();
        this.index = indexService.index();
        this.config = config;
        boolean allowNowinDlsQueries = settings.getAsBoolean("searchguard.unsupported.allow_now_in_dls", Boolean.valueOf(false));
        this.nowInMillis = allowNowinDlsQueries ? () -> System.currentTimeMillis() : () -> {
            throw new IllegalArgumentException("'now' is not allowed in DLS queries");
        };
    }

    public final DirectoryReader apply(DirectoryReader reader) throws IOException {
        Set unparsedDlsQueries;
        if (!this.config.get().isEnabled()) {
            return reader;
        }
        ShardId shardId = ShardUtils.extractShardId((DirectoryReader)reader);
        HashSet<String> flsFields = null;
        HashSet<String> maskedFields = null;
        ConstantScoreQuery dlsQuery = null;
        Map allowedFlsFields = (Map)((Object)HeaderHelper.deserializeSafeFromHeader((ThreadContext)this.threadContext, (String)"_sg_fls_fields"));
        Map queries = (Map)((Object)HeaderHelper.deserializeSafeFromHeader((ThreadContext)this.threadContext, (String)"_sg_dls_query"));
        Map maskedFieldsMap = (Map)((Object)HeaderHelper.deserializeSafeFromHeader((ThreadContext)this.threadContext, (String)"_sg_masked_fields"));
        String flsEval = SgUtils.evalMap((Map)allowedFlsFields, (String)this.index.getName());
        String dlsEval = SgUtils.evalMap((Map)queries, (String)this.index.getName());
        String maskedEval = SgUtils.evalMap((Map)maskedFieldsMap, (String)this.index.getName());
        if (flsEval != null) {
            flsFields = new HashSet<String>(metaFields);
            flsFields.addAll((Collection)allowedFlsFields.get(flsEval));
        }
        if (dlsEval != null && (unparsedDlsQueries = (Set)queries.get(dlsEval)) != null && !unparsedDlsQueries.isEmpty()) {
            SearchExecutionContext queryShardContext = this.indexService.newSearchExecutionContext(shardId.getId(), 0, null, this.nowInMillis, null, Collections.emptyMap());
            dlsQuery = new ConstantScoreQuery((Query)this.dlsQueryParser.parse(unparsedDlsQueries, queryShardContext).build());
        }
        if (maskedEval != null) {
            maskedFields = new HashSet<String>();
            maskedFields.addAll((Collection)maskedFieldsMap.get(maskedEval));
        }
        return new DlsFlsFilterLeafReader.DlsFlsDirectoryReader(reader, (Set<String>)flsFields, (Query)dlsQuery, this.indexService, this.threadContext, this.clusterService, this.complianceConfig, this.auditlog, (Set<String>)maskedFields, shardId);
    }
}

